/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.PropertyFileConfiguration;
import org.jfree.base.config.SystemPropertyConfiguration;
import org.jfree.base.modules.PackageManager;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public abstract class AbstractBoot {
    private PackageManager packageManager;
    private Configuration globalConfig;

    protected AbstractBoot() {
    }

    public synchronized PackageManager getPackageManager() {
        if (this.packageManager == null) {
            this.packageManager = PackageManager.createInstance(this);
        }
        return this.packageManager;
    }

    public synchronized Configuration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
        }
        return this.globalConfig;
    }

    protected abstract Configuration loadConfiguration();

    protected Configuration createDefaultHierarchicalConfiguration(String staticConfig, String userConfig, boolean addSysProps) {
        HierarchicalConfiguration globalConfig = new HierarchicalConfiguration();
        if (staticConfig != null) {
            PropertyFileConfiguration rootProperty = new PropertyFileConfiguration();
            rootProperty.load(staticConfig);
            globalConfig.insertConfiguration(rootProperty);
            globalConfig.insertConfiguration(this.getPackageManager().getPackageConfiguration());
        }
        if (userConfig != null) {
            String userConfigStripped = userConfig.startsWith("/") ? userConfig.substring(1) : userConfig;
            try {
                PropertyFileConfiguration baseProperty;
                Enumeration<URL> userConfigs = ObjectUtilities.getClassLoader(this.getClass()).getResources(userConfigStripped);
                ArrayList<PropertyFileConfiguration> configs = new ArrayList<PropertyFileConfiguration>();
                while (userConfigs.hasMoreElements()) {
                    URL url = userConfigs.nextElement();
                    try {
                        baseProperty = new PropertyFileConfiguration();
                        InputStream in = url.openStream();
                        baseProperty.load(in);
                        in.close();
                        configs.add(baseProperty);
                    }
                    catch (IOException ioe) {
                        Log.warn("Failed to load the user configuration at " + url, ioe);
                    }
                }
                for (int i = configs.size() - 1; i >= 0; --i) {
                    baseProperty = (PropertyFileConfiguration)configs.get(i);
                    globalConfig.insertConfiguration(baseProperty);
                }
            }
            catch (IOException e) {
                Log.warn("Failed to lookup the user configurations.", e);
            }
        }
        SystemPropertyConfiguration systemConfig = new SystemPropertyConfiguration();
        globalConfig.insertConfiguration(systemConfig);
        return globalConfig;
    }
}

