/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.io.Serializable;

public final class RectangleEdge
implements Serializable {
    public static final RectangleEdge TOP = new RectangleEdge("RectangleEdge.TOP");
    public static final RectangleEdge BOTTOM = new RectangleEdge("RectangleEdge.BOTTOM");
    public static final RectangleEdge LEFT = new RectangleEdge("RectangleEdge.LEFT");
    public static final RectangleEdge RIGHT = new RectangleEdge("RectangleEdge.RIGHT");
    private String name;

    private RectangleEdge(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RectangleEdge)) {
            return false;
        }
        RectangleEdge order = (RectangleEdge)o;
        return this.name.equals(order.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static boolean isTopOrBottom(RectangleEdge edge) {
        return edge == TOP || edge == BOTTOM;
    }

    public static boolean isLeftOrRight(RectangleEdge edge) {
        return edge == LEFT || edge == RIGHT;
    }

    public static RectangleEdge opposite(RectangleEdge edge) {
        RectangleEdge result = null;
        if (edge == TOP) {
            result = BOTTOM;
        } else if (edge == BOTTOM) {
            result = TOP;
        } else if (edge == LEFT) {
            result = RIGHT;
        } else if (edge == RIGHT) {
            result = LEFT;
        }
        return result;
    }
}

